function dydt=Film_growth_KMFILM_F(t,y)

global W sigma Db L_BL_close L_BL_far kbr
global a0 kd V_BL_close
global V_BL_far delta_BL_close delta_BL_far Dg_eddy Koa
global V_w L_bulk NCom mfp delta_x A ka

%%%%Initialize matrix size%%%%
dydt=zeros(NCom*(L_BL_close+L_BL_far+3+L_bulk),1);
%----------------------------------------------------------
for j=L_BL_close+L_BL_far+3
    for m=L_BL_close+L_BL_far+4:L_BL_close+L_BL_far+3+L_bulk
%Sorption layer surface coverage
Thetas=(sigma(1)*y(j)+sigma(2)*y(m+j)+sigma(3)*y(2*m+j)+sigma(4)*y(3*m+j)+sigma(5)*y(4*m+j)+sigma(6)*y(5*m+j)+sigma(7)*y(6*m+j))./A;
    end
end

%%%%Layer volumes and thicknesses%%%%
for i=1:L_bulk
    for j=L_BL_close+L_BL_far+3
        for m=1:NCom
    V_species(i,m)=y((j+L_bulk)*(m-1)+j+i)*V_w(m); %Contribution of each species to the volume of a layer (cm3)   
        end
    end
end
for i=1:L_bulk
    V(i,1)=sum(V_species(i,1:NCom)); %Total volume of each bulk layer (cm3)
    delta(i,1)=V(i,1)./A; %Thickness of each bulk layer (cm)
end

%%%%Bulk and sorption layer concentrations of each species%%%%
for i=1:NCom
    for j=1:L_bulk
        %Bulk concentrations (cm-3) 
        Xb(i,j)=y((L_BL_close+L_BL_far+3+L_bulk)*(i-1)+L_BL_close+L_BL_far+3+j)./V(j);
    end
end
for i=1:NCom
    %Sorption layer concentrations (cm-2)
    Xs(i)=y((L_BL_close+L_BL_far+3+L_bulk)*(i-1)+L_BL_close+L_BL_far+3)./A;
end

%Mass transport rates and fluxes
for i=1:6 %volatile species
    for m=L_BL_close+L_BL_far+3+L_bulk
Jcoll(i,1)=W(i)./4.*y((i-1)*m+1); %Collision flux with the film surface (cm-2 s-1)
Jads(i,1)=a0(i).*(1-Thetas).*Jcoll(i,1); %Adsorption flux with the film surface (cm-2 s-1)
Jdes(i,1)=kd(i)*Xs(i); %Desorption flux from the film surface (cm-2 s-1)
    end
end
for i=[7,8] %non-volatile species
    for m=L_BL_close+L_BL_far+3+L_bulk
Jcoll(i,1)=0; %Collision flux with the film surface (cm-2 s-1)
Jads(i,1)=0; %Adsorption flux with the film surface (cm-2 s-1)
Jdes(i,1)=0; %Desorption flux from the film surface (cm-2 s-1)
    end
end

for i=1:6 %volatile species
    kbs(i,1)=2.*Db(i)./(delta_x(i)+delta(1)); %Transport rate from the bulk to the surface (cm s-1)
    ksb(i,1)=Koa(i).*kbs(i,1).*kd(i)/(ka(i).*(1-Thetas)); %Transport rate from the surface to the bulk (s-1)
    Jsb(i,1)=ksb(i,1).*Xs(i); %Transport flux from the surface to the bulk (cm-2 s-1)
    Jbs(i,1)=kbs(i,1).*Xb(i,1); %Transport flux from the bulk to the surface (cm-2 s-1)
end
for i=[7,8] %Non-volatile species
    kbs(i,1)=0; %Transport rate from the bulk to the surface (cm s-1)
    ksb(i,1)=0; %Transport rate from the surface to the bulk (s-1)
    Jsb(i,1)=0; %Transport flux from the surface to the bulk (cm-2 s-1)
    Jbs(i,1)=0; %Transport flux from the bulk to the surface (cm-2 s-1)
end
for i=1:NCom
    for m=1:L_bulk-1
        kbb(i,m,m+1)=2.*Db(i)./(delta(m)+delta(m+1)); %Transport rates between bulk layers (cm s-1)
        kbb(i,m+1,m)=2.*Db(i)./(delta(m+1)+delta(m)); %Transport rates between bulk layers (cm s-1)
    end
end
for i=1:NCom
    for m=1:L_bulk-1
        Jbb(i,m,m+1)=kbb(i,m,m+1).*Xb(i,m); %Transport fluxes between bulk layers (cm-2 s-1)
        Jbb(i,m+1,m)=kbb(i,m+1,m).*Xb(i,m+1); %Transport fluxes between bulk layers (cm-2 s-1)
    end
end

%%%%Production rates due to chemical reactions (cm-3 s-1)%%%%
for j=1:L_bulk
    Pb(1,j)=0;
    Pb(2,j)=-kbr*Xb(2,j)*Xb(6,j);
    Pb(3,j)=0;
    Pb(4,j)=0;
    Pb(5,j)=0;
    Pb(6,j)=-kbr*Xb(2,j)*Xb(6,j);
    Pb(7,j)=kbr*Xb(2,j)*Xb(6,j);
    Pb(8,j)=0;
end

%%%%Differential equations: Change in concentrations and molecule numbers over time%%%%
for m=L_BL_close+L_BL_far+3+L_bulk
for i=1:6
%Mean free path (cm-3 s-1)
    dydt((i-1)*m+1)= (Jdes(i,1)-Jads(i,1))./mfp(i)+...
        Dg_eddy(i,1)./(delta_BL_close/2)./mfp(i)*(y((i-1)*m+2)-y((i-1)*m+1));
%First layer in the close boundary layer (cm-3 s-1)    
    dydt((i-1)*m+2)= Dg_eddy(i,1)./(delta_BL_close/2).*A./V_BL_close*(y((i-1)*m+1)-y((i-1)*m+2))+...
        Dg_eddy(i,2)./delta_BL_close.*A./V_BL_close*(y((i-1)*m+3)-y((i-1)*m+2));
%Middle layers in the close boundary layer (cm-3 s-1) 
    for j=1:L_BL_close-2
    dydt((i-1)*m+j+2)= Dg_eddy(i,j+1)./delta_BL_close.*A./V_BL_close*(y((i-1)*m+1+j)-y((i-1)*m+2+j))+...
        Dg_eddy(i,j+2)./delta_BL_close.*A./V_BL_close*(y((i-1)*m+3+j)-y((i-1)*m+2+j));
    end
%Final layer in the close boundary layer (cm-3 s-1)     
    dydt((i-1)*m+L_BL_close+1)=Dg_eddy(i,L_BL_close)./delta_BL_close.*A./V_BL_close*(y((i-1)*m+L_BL_close)-y((i-1)*m+L_BL_close+1))+...
        Dg_eddy(i,L_BL_close+1)./(delta_BL_close/2+delta_BL_far/2).*A./V_BL_close*(y((i-1)*m+L_BL_close+2)-y((i-1)*m+L_BL_close+1)); 
%First layer in the boundary layer further away from the surface (cm-3 s-1)  
    dydt((i-1)*m+L_BL_close+2)=Dg_eddy(i,L_BL_close+1)./(delta_BL_close/2+delta_BL_far/2).*A./V_BL_far*(y((i-1)*m+L_BL_close+1)-y((i-1)*m+L_BL_close+2))+...
        Dg_eddy(i,L_BL_close+2)./delta_BL_far.*A./V_BL_far*(y((i-1)*m+L_BL_close+3)-y((i-1)*m+L_BL_close+2)); 
%Middle layers in the boundary layer further away from the surface (cm-3 s-1)
    for j=1:L_BL_far-2
    dydt((i-1)*m+L_BL_close+2+j)= Dg_eddy(i,j+L_BL_close+1)./delta_BL_far.*A./V_BL_far*(y((i-1)*m+1+L_BL_close+j)-y((i-1)*m+2+L_BL_close+j))+...
        Dg_eddy(i,j+L_BL_close+2)./delta_BL_far.*A./V_BL_far*(y((i-1)*m+3+L_BL_close+j)-y((i-1)*m+2+L_BL_close+j));
    end
%Final layer in the boundary layer further away from the surface (cm-3 s-1)    
    dydt((i-1)*m+L_BL_close+L_BL_far+1)= Dg_eddy(i,L_BL_close+L_BL_far)./delta_BL_far.*A./V_BL_far*(y((i-1)*m+L_BL_close+L_BL_far)-y((i-1)*m+L_BL_close+L_BL_far+1))+...
        Dg_eddy(i,L_BL_close+L_BL_far+1)./(delta_BL_far/2).*A./V_BL_far*(y((i-1)*m+L_BL_close+L_BL_far+2)-y((i-1)*m+L_BL_close+L_BL_far+1));
%Gas phase (cm-3 s-1)
    dydt((i-1)*m+L_BL_close+L_BL_far+2)=0;
%Sorption layer (Molecules s-1)
    dydt((i-1)*m+L_BL_close+L_BL_far+3)= (Jads(i,1)-Jdes(i,1)).*A+...
        (Jbs(i,1)-Jsb(i,1)).*A;
end
for i=1:NCom
    %First bulk layer(Molecules s-1)    
    dydt((i-1)*m+L_BL_close+L_BL_far+4)=(Jsb(i,1)-Jbs(i,1)).*A+...
        (Jbb(i,2,1)-Jbb(i,1,2)).*A+Pb(i,1).*V(1,1);
    if L_bulk>=3
    for k=1:L_bulk-2
    %Middle bulk layers (Molecules s-1)   
    dydt((i-1)*m+L_BL_close+L_BL_far+4+k)=(Jbb(i,k,k+1)-Jbb(i,k+1,k)).*A+...
        (Jbb(i,k+2,k+1)-Jbb(i,k+1,k+2)).*A+Pb(i,k+1).*V(k+1,1);
    end
    end
    %Final bulk layer (Molecules s-1)   
    dydt((i-1)*m+L_BL_close+L_BL_far+3+L_bulk)=(Jbb(i,L_bulk-1,L_bulk)-Jbb(i,L_bulk,L_bulk-1)).*A+Pb(i,L_bulk).*V(L_bulk,1);
end
end
end